package org.msh.tb.reports2.variables.contacts;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.reports2.variables.AgeRange2Variable;

/**
 * Created by rmemoria on 30/3/17.
 */
public class ContactAgeRangeVariable extends AgeRange2Variable {
    public ContactAgeRangeVariable() {
        super();
        setId("contact-id");
        setKeylabel("manag.reportgen.var.contact-age");
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender is not null");
        def.select(alias + ".gender");
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender is not null");
        setFieldName(alias + ".gender");
        super.prepareFilterQuery(def, oper, value);
    }


}
